VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DLXOCX32.OCX"
Begin VB.Form Main 
   Appearance      =   0  'Flat
   BackColor       =   &H80000005&
   Caption         =   "CTM-05/A Event Counting Register Level Example"
   ClientHeight    =   4470
   ClientLeft      =   2865
   ClientTop       =   1590
   ClientWidth     =   5895
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   LinkMode        =   1  'Source
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   4470
   ScaleWidth      =   5895
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   4560
      TabIndex        =   9
      Top             =   3480
      Width           =   735
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   5040
      Top             =   1800
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   5040
      Top             =   2400
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.CommandButton Initialize 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "Initialize"
      Enabled         =   0   'False
      Height          =   615
      Left            =   960
      TabIndex        =   6
      Top             =   1320
      Width           =   975
   End
   Begin VB.TextBox BasAdr 
      Appearance      =   0  'Flat
      Enabled         =   0   'False
      Height          =   285
      Left            =   4320
      TabIndex        =   2
      Text            =   "Base"
      Top             =   840
      Width           =   855
   End
   Begin VB.CommandButton ZeroCounters 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "ZERO"
      Enabled         =   0   'False
      Height          =   615
      Left            =   960
      TabIndex        =   1
      Top             =   3000
      Width           =   975
   End
   Begin VB.PictureBox CountData 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      ForeColor       =   &H80000008&
      Height          =   1095
      Left            =   3720
      ScaleHeight     =   1065
      ScaleWidth      =   705
      TabIndex        =   4
      Top             =   2040
      Width           =   735
   End
   Begin VB.CommandButton ReadCounters 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "READ"
      Enabled         =   0   'False
      Height          =   615
      Left            =   960
      TabIndex        =   0
      Top             =   2160
      Width           =   975
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   435
      Left            =   480
      TabIndex        =   8
      Top             =   120
      Width           =   2295
   End
   Begin VB.Label Label1 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "CTM BASE ADDRESS"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   1680
      TabIndex        =   3
      Top             =   840
      Width           =   2175
   End
   Begin VB.Label Label3 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "Counter # 1 Counter # 2 Counter # 3 Counter # 4 Counter # 5"
      ForeColor       =   &H80000008&
      Height          =   975
      Left            =   2520
      TabIndex        =   7
      Top             =   2040
      Width           =   1095
   End
   Begin VB.Label Label2 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "COUNT DATA"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   3000
      TabIndex        =   5
      Top             =   1560
      Width           =   1335
   End
End
Attribute VB_Name = "Main"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'
' this example was written for the CTM-05/A board
' it uses DriverLINX only to dynamically determine the base address of the board
' from the driver (LDD object) and to use the DLOutp and DLInp methods to do port
' I/O to the registers of the CTM board.  It does not use the driver to otherwise program the board.
'
' the port I/O sequence of events to program 5 counters of an Am9513 chip for event counting
' are demonstrated in this program.
'
' these port I/O methods of the SR control work only in Win9x.  For same
' functionality in WinNT or higher, get a port I/O utility with kernel mode access such
' as the 32bit Port I/O free ware driver from SST.  This is available on the Keithley
' web site.
Dim BaseAddress As Integer
Dim Index As Integer
Dim ReturnData(5) As Single
Dim SaveBase As String

Private Sub cmdExit_Click()
Form_Unload 0
End
End Sub

Private Sub Form_Load()
Dim addr As String
ReadCounters.Enabled = False
ZeroCounters.Enabled = False
SR.Req_DLL_name = "kmbctm$"  ' $ on end means load only the kmbctm driver
SR.Req_mode = DL_OTHER
SR.Req_op = DL_INITIALIZE
SR.Req_subsystem = DL_DEVICE
SR.Req_device = 0           ' hard coded for device 0. must agree with assignment in dlinx config panel
SR.Refresh
If SR.Res_result = DL_NoErr Then
' we were able to init the device, so it is here and driver installed
LDD.Req_DLL_name = SR.Req_DLL_name
LDD.device = SR.Req_device  ' load the LDD with the SR device/driver info
LDD.Refresh   ' get fresh data about this device/driver combo

addr = Str(LDD.Dev_IOaddr)  ' such as the base address
BasAdr.Text = "&H" + Right(addr, 3)  ' display the address on the form
BaseAddress = LDD.Dev_IOaddr
SaveBase = Str(Hex(LDD.Dev_IOaddr))
' enable the other buttons
Initialize.Enabled = True
Else
MsgBox "This example requires the installation of DriverLINX for CTM boards, a configured Device 0, and Win9x.", vbCritical
End
End If
End Sub


Private Sub Form_Unload(Cancel As Integer)
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End Sub

Private Sub Initialize_Click()
'*** initialize 9513 on CTM-05 board ***
'You must call this routine in the initializing section of your program.
'It sets up each counter to count up with SRC(n) as each clock input.
'SETTING THE MASTER MODE REGISTER
'First set the data pointer register through the command register
'The command code is as follows:-
'  1. C7-5 = 000 (Load data pointer register)
'  2. C4-3 = 10  (Element pointer = master mode register)
'  3. C2-0 = 111 (Group pointer = control)
'This decodes to a byte 0001 0111 or &H17

'DASErr = DASByteOut(BaseAddress + 1, &H17)
SR.DLOutp BaseAddress + 1, &H17

'Next write to the master mode register
'We are setting up for the following conditions:-
'(Conditions marked X don't matter as we are not using these functions)
'  1. BCD division on scaler        MM15 = 1 (X)
'  2. Data pointer control          MM14 = 1 (enabled)
'  3. Data bus width = 8 bits       MM13 = 0
'  4. FOUT on                       MM12 = 0 (X)
'  5. FOUT divider = 10             MM11-8 = 1010 (X)
'  6. FOUT source = F5 (100Hz)      MM7-4 = 1111 (X)
'  7. Compare 2 disabled            MM3 = 0
'  8. Compare 1 disabled            MM2 = 0
'  9. Time of day mode disabled     MM1-0 = 00

'This makes a master mode word of 1100 1010 1111 0000 or &HCAF0
'This is written as 2 sequential bytes lo/hi &HF0 followed by &HCA

'DASErr = DASByteOut(BaseAddress, &HF0): DASErr = DASByteOut(BaseAddress, &HCA)

SR.DLOutp BaseAddress, &HF0
SR.DLOutp BaseAddress, &HCA

'SETTING INDIVIDUAL COUNTER MODE REGISTERS
'Now we can write to each individual counter mode register
'To do this we set the data pointer first through the command register

'DASErr = DASByteOut(BaseAddress + 1, &H1)               'data pointer for Ctr. 1
SR.DLOutp BaseAddress + 1, &H1

'Now set counter 1 mode register as follows:-
'   1. No gating                    CM15-13 = 000
'   2. Count on rising edge         CM12 = 0
'   3. Input = SRC1                 CM11-8 = 0001
'   4. Disable special gate         CM7 = 0
'   5. Reload from load             CM6 = 0
'   6. Count repetitively           CM5 = 1 (lets you cascade ctrs.)
'   7. Binary count                 CM4 = 0
'   8. Count up                     CM3 = 1
'   9. Active low T/C pulse         CM2-0 = 101
'Counter 1 mode word = 0000 0001 0010 1101 or &H012D

'mode for Ctr. 1
SR.DLOutp BaseAddress, &H2D
SR.DLOutp BaseAddress, &H1

'Finally set modes of all other counters
'data pointer for Ctr. 2
SR.DLOutp BaseAddress + 1, &H2
'mode for Ctr. 2, SRC2 selected
SR.DLOutp BaseAddress, &H2D
SR.DLOutp BaseAddress, &H2

'data pointer for Ctr. 3
SR.DLOutp BaseAddress + 1, &H3
'mode for Ctr. 3, SRC3 selected
SR.DLOutp BaseAddress, &H2D
SR.DLOutp BaseAddress, &H3

'data pointer for Ctr. 4
SR.DLOutp BaseAddress + 1, &H4
'mode for Ctr. 4, SRC4 selected
SR.DLOutp BaseAddress, &H2D
SR.DLOutp BaseAddress, &H4

'data pointer for Ctr. 5
SR.DLOutp BaseAddress + 1, &H5
'mode for Ctr. 5, SRC5 selected
SR.DLOutp BaseAddress, &H2D
SR.DLOutp BaseAddress, &H5

ReadCounters.Enabled = True
ZeroCounters.Enabled = True

ZeroCounters_click
End Sub

Private Sub ReadCounters_Click()
Dim CL As Long
Dim CH As Long

'*** Subroutine to latch and read all counters ***
'This does not interfere with counting or change data
'Data is returned in ReturnData(n)

'save data to all hold latches
SR.DLOutp BaseAddress + 1, &HBF
'Now read data from each hold latch

 'point to Ctr. 1 hold register
SR.DLOutp BaseAddress + 1, &H11
CL = SR.DLInp(BaseAddress)   'read hold latch
CH = SR.DLInp(BaseAddress)
ReturnData(1) = 256 * CH + CL         'calculate count

 'point to Ctr. 2 hold register
SR.DLOutp BaseAddress + 1, &H12
CL = SR.DLInp(BaseAddress)
CH = SR.DLInp(BaseAddress)
ReturnData(2) = 256 * CH + CL         'calculate count

'point to Ctr. 3 hold register
SR.DLOutp BaseAddress + 1, &H13
CL = SR.DLInp(BaseAddress)
CH = SR.DLInp(BaseAddress)
ReturnData(3) = 256 * CH + CL         'calculate count

'point to Ctr. 4 hold register
SR.DLOutp BaseAddress + 1, &H14
CL = SR.DLInp(BaseAddress)
CH = SR.DLInp(BaseAddress)
ReturnData(4) = 256 * CH + CL         'calculate count

'point to Ctr. 5 hold register
SR.DLOutp BaseAddress + 1, &H15
CL = SR.DLInp(BaseAddress)
CH = SR.DLInp(BaseAddress)
ReturnData(5) = 256 * CH + CL         'calculate count

CountData.Cls
For Index = 1 To 5
' have to deal with VB's always signed values....
' counters go from 0 to 65535 and then roll over....
  If ReturnData(Index) < 0 Then ReturnData(Index) = ReturnData(Index) + 65536
    CountData.Print ReturnData(Index)
Next Index
End Sub

Private Sub ZeroCounters_click()
Dim Index As Integer


'*** reset (zero) all counters ***
'Disarm all counters (stop counting)
SR.DLOutp BaseAddress + 1, &HDF

'Enter zero to each counter load register
'point to load register Ctr.1
SR.DLOutp BaseAddress + 1, &H9
SR.DLOutp BaseAddress, &H0  'write zero to it
SR.DLOutp BaseAddress, &H0

'point to load register Ctr.2
SR.DLOutp BaseAddress + 1, &HA
SR.DLOutp BaseAddress, &H0
SR.DLOutp BaseAddress, &H0

'point to load register Ctr.3
SR.DLOutp BaseAddress + 1, &HB
SR.DLOutp BaseAddress, &H0
SR.DLOutp BaseAddress, &H0

'point to load register Ctr.4
SR.DLOutp BaseAddress + 1, &HC
SR.DLOutp BaseAddress, &H0
SR.DLOutp BaseAddress, &H0

'point to load register Ctr.5
SR.DLOutp BaseAddress + 1, &HD
SR.DLOutp BaseAddress, &H0
SR.DLOutp BaseAddress, &H0

'Now load (reset) and arm (enable counting) on all counters
SR.DLOutp BaseAddress + 1, &H7F

CountData.Cls
For Index = 1 To 5
    CountData.Print 0
Next

End Sub

